#version 140
#extension GL_EXT_gpu_shader4 : enable
// flying fractalMod01.fsh  by foran

//https://www.shadertoy.com/view/wtjXRR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform vec4 iDate;
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
 * inspired by http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/
*/
#define N 60
void main (void)
//void mainImage(out vec4 fragColor,in vec2 fragCoord)
{
	vec2 v = (gl_FragCoord.xy - iResolution.xy/2.0) / min(iResolution.y,iResolution.x) * 20.0;
	vec2 m = iDate.zw;
	m=vec2(cos(.914+iTime*0.009), sin(.9*iTime*0.019)); 
	float rsum = 0.0;
	float pi2 = 3.1415926535 * 2.0;
	float a = (m.x-.5)*pi2;
	float C = cos(a);
	float S = sin(a);
	vec2 xaxis=vec2(C, -S);
	vec2 yaxis=vec2(S, C);
	float maxcycle=0.0;
	vec2 shift = vec2( 0, 1.618);
	float zoom = 1.0 + m.y*8.0;
	for ( int i = 0; i < N; i++ ){
		float rr = dot(v,v);
		if ( rr > 0.618 ){
			rr = 1.618/rr ;
			v.x = v.x * rr;
			v.y = v.y * rr;
		}
		if(rr > rsum)
		{
			rsum = rr;
			maxcycle = float(i);
		}

		v = vec2( dot(v,xaxis), dot(v,yaxis)) * zoom + shift;
	}
	
	float col = rsum/2.618;
	col = .2 + 2.0 * min(col, 1.0-col);
	float red, green, blue;
	
	red = fract(cos(maxcycle));
	green = fract(cos(maxcycle*1.2));
	blue = fract(cos(maxcycle*1.5));
	
	gl_FragColor = vec4(vec3(red, green, blue)*col*col, 1.0);
}





